function plotcontourstruct( contours, linestyle )
% plotcontourstruct( contours )
% 
% Plot contours from a contour struct created by contourstruct.m using plot 
% function rather than contour function. This allows 
% contours to be plotted on top of a surface with a different range
% (and therefore not disturbing its' colormap. For example it can be used
% to plot contours of the gradient of a surface on top of the surface. Or
% for plotting streamlines on top of the head gradient map.
% 
% Created by Yannick Kremer 2010
% University of Strathclyde
% Glasgow
% mail@ykremer.com

for idx = 1 : length( contours ),
    plot( contours( idx ).x, contours( idx ).y, linestyle)
    hold on
end